Attribute VB_Name = "Macros"
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  Name:    ExportDelimitedText
'  Purpose: Exports  worksheet range or selection to a tab or comma-delimited text file
'  Author:  Dave Stewart
'  website: www.keyframesandcode.com
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Const TSV As String = "txt"
Const CSV As String = "csv"

Sub ExportTSV()
Attribute ExportTSV.VB_Description = "Export worksheet as tab-delimited text"
Attribute ExportTSV.VB_ProcData.VB_Invoke_Func = "e\n14"
    ExportTextFile TSV
End Sub


Sub ExportCSV()
    ExportTextFile CSV
End Sub


Private Sub ExportTextFile(format As String)
            
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    ' EXPORT
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        
        ' variables
            Dim filename As Variant
            Dim selectionOnly As Boolean
            
        ' prompt for selection only
            If Selection.Count > 1 Then
                selectionOnly = MsgBox("Do you wish to export the selection only?", vbYesNo)
            End If
            
        ' get fileName
            If format = TSV Then
                filename = Application.GetSaveAsFilename(InitialFileName:=ActiveSheet.Name & ".txt", FileFilter:="Text Files (*.txt),*.txt", Title:="Export tab-delimited text file")
            Else
                filename = Application.GetSaveAsFilename(InitialFileName:=ActiveSheet.Name & ".csv", FileFilter:="Text Files (*.csv),*.csv", Title:="Export comma-delimited text file")
            End If
            
        ' exit on cancel
            If filename = False Then
                Exit Sub
            End If
            
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    ' EXPORT
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        
        ' variables
            ' output
                Dim output As String
                Dim cellText As String
                Dim rxTrim As Object
                
            ' file
                Dim appendFile As Boolean
                Dim fileHandle As Integer
                
            ' range
                Dim rowStart As Long
                Dim rowEnd As Long
                Dim colStart As Integer
                Dim colEnd As Integer
                
            ' coords
                Dim rowIndex As Long
                Dim colIndex As Integer
                
            ' variables
                Dim delim As String
            
        ' consts
            Const QUOTE As String = """"
            
        ' assignments
            filename = CStr(filename)
            appendFile = False
            If format = TSV Then delim = vbTab Else delim = ","
            
        ' regexp
            Set rxTrim = CreateObject("vbscript.regexp")
            With rxTrim
                .MultiLine = False
                .Global = True
                .IgnoreCase = True
                .Pattern = "(^\s+|\s+$)"
            End With
            
        ' debug
            Debug.Print "fileName: " & filename & " Selection only: " & selectionOnly

        ' setup
            Application.ScreenUpdating = False
            On Error GoTo EndMacro:
            fileHandle = FreeFile
            
        ' set used range
            If selectionOnly = True Then
                With Selection
                    rowStart = .Cells(1).Row
                    colStart = .Cells(1).Column
                    rowEnd = .Cells(.Cells.Count).Row
                    colEnd = .Cells(.Cells.Count).Column
                End With
            Else
                With ActiveSheet.UsedRange
                    rowStart = .Cells(1).Row
                    colStart = .Cells(1).Column
                    rowEnd = .Cells(.Cells.Count).Row
                    colEnd = .Cells(.Cells.Count).Column
                End With
            End If
            
        ' open fileName for writing
            On Error Resume Next

        ' open fileName for writing
            If appendFile = True Then
                Open filename For Append Access Write As #fileHandle
            Else
                Open filename For Output Access Write As #fileHandle
            End If
            
        ' open fileName for writing
            If Err.Number <> 0 Then
                MsgBox "The file cannot be saved at this time, because of a """ & Err.Description & """ error. Is it open in another window?", vbInformation
                Exit Sub
            End If

        ' iterate through cells for export
            For rowIndex = rowStart To rowEnd
                output = ""
                For colIndex = colStart To colEnd
                
                    ' cell text
                        cellText = Cells(rowIndex, colIndex).Text
                        cellText = rxTrim.replace(cellText, "")
                        
                    ' quote strings
                        If format = TSV And InStr(cellText, " ") Then
                            cellText = QUOTE & replace(cellText, QUOTE, QUOTE & QUOTE) & QUOTE
                        End If
                        
                    ' output
                        output = output & cellText & delim
                    
                Next colIndex
                output = Left(output, Len(output) - Len(delim))
                Print #fileHandle, output
            Next rowIndex
        
EndMacro:
    On Error GoTo 0
    Application.ScreenUpdating = True
    Close #fileHandle
        
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' END ExportTabDelimitedText
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

